
#ifndef SST_SEP_ATP_AUTHENTICATORS_H
#define SST_SEP_ATP_AUTHENTICATORS_H
#include "SST_SEP_TST.h"
/*
 * All the includes that are needed for code using this module to
 * compile correctly should be #included here.
 */

#ifdef __cplusplus
extern "C"
{
#endif

  /*
   *  Object %name    : %
   *  State           :  %state%
   *  Creation date   :  Apr 01 12:06:34 2009
   *  Last modified   :  %modify_time%
   */
  /** @file
   *  \brief A brief description of this module
   *
   *  \version SST_TST_ATP_Authenticators.h#1:incl:1
   *  \author TaniaM
   *  \remarks Copyright (C) 2007 by Discretix Technologies Ltd.
   *           All Rights reserved
   */

/************************ Structs  ******************************/
typedef struct TST_ATP_PassAuthTestDataStruct{	
    char					    TST_Name[TST_NAME_STRING_LEN];
    DxByte_t                    TST_MasterPassword[TST_PASSWORD_STRING_LEN];
    DxUint32_t                  TST_MasterPasswordSizeInBytes;
    DxUint32_t                  TST_MasterMaxNumOfTrials;
    DxByte_t                    TST_SecondaryPassword[TST_PASSWORD_STRING_LEN];
    DxUint32_t                  TST_SecondaryPasswordSizeInBytes;
    DxUint32_t                  TST_SecondaryMaxNumOfTrials;
    DxByte_t                    TST_NewSecPassword[TST_PASSWORD_STRING_LEN];
    DxUint32_t                  TST_NewSecPasswordSizeInBytes;
    DxUint32_t                  TST_NewSecMaxNumOfTrials;
    DxByte_t                    TST_Data[TST_TEMP_DATA_LENGTH];
    DxUint32_t                  TST_DataSize;
} TST_ATP_PassAuthTestDataStruct;


/*****************************************************************************
 * Function Name:
 *  SEPQA_SST_PasswordAuthenticator
 * 
 * Inputs:
 *  None
 *
 * Outputs:
 *  DxError_t - Function error return
 *
 * Description:
 * Test the creation, deletion, modification, opening, 
 * closing and usage of a password authenticator object. 
 * And demonstrate the use of transaction with authenticator objects
 *
 * Algorithm:
 *    1.  Create a new session by calling: SST_SessionCreate.
 *    2.  Open a transaction by calling: SST_TransactionStart.
 *    3.  Create a new master password authenticator by calling: SST_AuthenticatorPasswordCreate.
 *    4.  Close the transaction by calling: SST_TransactionEnd
 *    5.  Open the master password authentication by calling: SST_AuthenticationOpen.
 *    6.  Open a transaction by calling: SST_TransactionStart.
 *    7.  Create a new secondary password authenticator by calling: SST_AuthenticatorPasswordCreate.
 *    8.  Close the transaction by calling: SST_TransactionEnd. 
 *    9.  Open the secondary authenticator by calling: SST_AuthenticationOpen.
 *    10. Open a transaction by calling: SST_TransactionStart.
 *    11. Modify the password for the authenticator by calling: SST_AuthenticatorPasswordResetAndChange.
 *    12. Close the authenticator by calling: SST_AuthenticationClose.
 *    13. Close the transaction by calling: SST_TransactionEnd.
 *    14. Reopen the secondary authenticator using the new password by calling: SST_AuthenticationOpen.
 *    15. Close the authenticator by calling: SST_AuthenticationClose.
 *    16. Open the master authenticator using the new password by calling: SST_AuthenticationOpen.
 *    17. Open a transaction by calling: SST_TransactionStart.
 *    18. Insert a new data object by calling: SST_InsertData.
 *    19. Delete the data by calling: SST_DeleteData.
 *    20. Close the authenticator by calling: SST_AuthenticationClose.
 *    21. Delete the authenticators (one by one) by calling: SST_AuthenticatorDelete.
 *    22. Close the transaction by calling: SST_TransactionClose.
 *    23. Delete the session by calling: SST_SessionDelete.
 ********************************************************************************/
DxError_t SEPQA_SST_PasswordAuthenticator(void);


#ifdef __cplusplus
}


#endif

#endif

